$ErrorActionPreference = "Stop"
 
$downloadUrl = "https://github.com/thebookisclosed/ViVe/releases/download/v0.3.3/ViVeTool-v0.3.3.zip"
$tempPath = "C:\Windows\Temp"
$viveToolDir = "$tempPath\ViVeTool"
$viveToolExe = "$viveToolDir\ViVeTool.exe"
New-Item -Path $viveToolDir -ItemType Directory -Force | Out-Null
$featureIds = @(47557358, 45317806)
 
 
# Ensure ViVeTool exists
if (-not (Test-Path $viveToolExe)) {
    Invoke-WebRequest -Uri $downloadUrl -OutFile "$tempPath\ViVeTool.zip"
    Expand-Archive -Path "$tempPath\ViVeTool.zip" -DestinationPath $viveToolDir -Force
    Write-host "Downloaded and extracted ViVeTool."
} else {
    Write-host "ViVeTool already exists."
}
 
foreach ($featureId in $featureIds) {
    $result = & $viveToolExe /query /id:$featureId 2>&1
    Write-host "Queried Feature ID ${featureId}:`n$result"
 
    if ($result -match "State\s*:\s*Enabled") {
        Write-host "Feature ID ${featureId} is ENABLED. Detection failed."
        exit 1
    } else {
        Write-host "Feature ID ${featureId} is NOT enabled."
	exit 0
    }
}
 
 
Write-Log "No features are enabled. Detection succeeded."
exit 0